/* 
 *  KVPAttachedDataTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import static com.avaya.ccs.api.enums.DataFormat.KVP;

public class KVPAttachedDataTab extends KVPTab {

    public KVPAttachedDataTab(Logger LOG, InteractionExecutor interactionExe, InteractionDataGUI gui) {
        super(LOG, interactionExe, gui, "KVP");
    }

    @Override
    void update(InteractionDataI data) {
        getTab().setDisable(!enableTab(data));
        getList().clear();
        getList().addAll(KVPItem.convertKVPData(data.getData()));
    }

    @Override
    void add(String interactionID, String newName, String newValue) {
        interactionExe.addKVPDATA(interactionID, newName, newValue);
    }

    @Override
    void edit(String interactionID, String name, String newValue) {
        interactionExe.editKVPDATA(interactionID, name, newValue);
    }

    @Override
    void remove(String interactionID, String name) {
        interactionExe.removeKVPDATA(interactionID, name);
    }

    private Boolean enableTab(InteractionDataI data) {
        if (!data.canGetData()) {
            return false;
        }

        return data.getData() == null || data.getData().getFormat().equals(KVP);
    }

}
